/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.epsilon;

import com.alcatrazescapee.epsilon.SpecBuilder;
import com.alcatrazescapee.epsilon.TypedValue;
import com.alcatrazescapee.epsilon.ValueConverter;
import com.alcatrazescapee.epsilon.value.Value;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public final class Spec {
    private final Node root;

    public static SpecBuilder builder() {
        return new Builder();
    }

    Spec(Node root) {
        this.root = root;
    }

    void write(FileWriter writer) throws IOException {
        this.root.write(writer, 0);
    }

    void parse(Map<String, Object> element, Consumer<String> error) {
        this.root.parse(element, error);
    }

    void reset() {
        this.root.reset();
    }

    static class Builder
    implements SpecBuilder {
        private static final Pattern NAME_PATTERN = Pattern.compile("[A-Za-z][A-Za-z0-9-_]*");
        private final List<Node> stack = new ArrayList<Node>();
        private String[] comment;

        Builder() {
            this.stack.add(new Node("", null));
            this.comment = null;
        }

        @Override
        public SpecBuilder push(String name) {
            Node top = this.peek();
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Name is not allowed to be empty.");
            Preconditions.checkArgument((!top.containsKey(name) ? 1 : 0) != 0, (Object)("Name '" + name + "' is already defined."));
            Preconditions.checkArgument((boolean)NAME_PATTERN.matcher(name).matches(), (Object)"Name must match the pattern [A-Za-z][A-Za-z0-9-_]*");
            Node node = new Node((String)(top.name.isEmpty() ? name : top.name + "." + name), this.comment);
            top.children.put(name, node);
            this.stack.add(node);
            this.comment = null;
            return this;
        }

        @Override
        public SpecBuilder pop() {
            Preconditions.checkArgument((this.stack.size() > 1 ? 1 : 0) != 0, (Object)"Tried to pop from an empty stack.");
            this.stack.remove(this.stack.size() - 1);
            return this;
        }

        @Override
        public SpecBuilder comment(String ... comment) {
            this.comment = this.comment == null ? comment : (String[])ArrayUtils.addAll((Object[])this.comment, (Object[])comment);
            return this;
        }

        @Override
        public <T, U, V extends Value<U>> V define(String name, U defaultValue, ValueConverter<T, U, V> converter) {
            Preconditions.checkArgument((boolean)NAME_PATTERN.matcher(name).matches(), (Object)"Name must match the pattern [A-Za-z][A-Za-z0-9-_]*");
            Preconditions.checkArgument((!this.peek().containsKey(name) ? 1 : 0) != 0, (Object)("Name '" + name + "' is already defined."));
            V value = converter.create(defaultValue);
            String longName = this.stack.size() <= 1 ? name : this.peek().name + "." + name;
            this.peek().values.put(name, new TypedValue<T, U, V>(name, longName, this.comment, value, defaultValue, converter));
            value.set(defaultValue);
            this.comment = null;
            return value;
        }

        @Override
        public Spec build() {
            Preconditions.checkArgument((this.stack.size() == 1 ? 1 : 0) != 0, (Object)"Unclosed categories in stack.");
            return new Spec(this.peek());
        }

        private Node peek() {
            return this.stack.get(this.stack.size() - 1);
        }
    }

    record Node(String name, @Nullable String[] comment, Map<String, Node> children, Map<String, TypedValue<?, ?, ?>> values) {
        Node(String name, @Nullable String[] comment) {
            this(name, comment, new LinkedHashMap<String, Node>(), new LinkedHashMap());
        }

        boolean containsKey(String key) {
            return this.children.containsKey(key) || this.values.containsKey(key);
        }

        void write(FileWriter writer, int depth) throws IOException {
            String prefix = "    ".repeat(depth);
            for (Map.Entry<String, TypedValue<?, ?, ?>> entry : this.values.entrySet()) {
                TypedValue<?, ?, ?> typed = entry.getValue();
                if (typed.comment() != null) {
                    String[] stringArray = typed.comment();
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String line = stringArray[i];
                        writer.write("%s# %s\n".formatted(prefix, line));
                    }
                }
                writer.write("%s%s = %s\n\n".formatted(prefix, typed.name(), typed.write()));
            }
            for (Node value : this.children.values()) {
                writer.write("\n");
                if (value.comment() != null) {
                    for (String line : value.comment()) {
                        writer.write("%s# %s\n".formatted(prefix, line));
                    }
                }
                writer.write("%s[%s]\n\n".formatted(prefix, value.name));
                value.write(writer, depth + 1);
            }
        }

        void parse(Map<String, Object> map, Consumer<String> error) {
            for (TypedValue<?, ?, ?> typed : this.values.values()) {
                Object value = map.get(typed.longName());
                if (value != null) {
                    typed.parse(value, error);
                    continue;
                }
                error.accept("Missing value for: '%s'".formatted(typed.longName()));
            }
            for (Node value : this.children.values()) {
                value.parse(map, error);
            }
        }

        void reset() {
            for (TypedValue<?, ?, ?> typedValue : this.values.values()) {
                typedValue.reset();
            }
            for (Node node : this.children.values()) {
                node.reset();
            }
        }
    }

    @FunctionalInterface
    static interface FileWriter {
        public void write(String var1) throws IOException;
    }
}

