/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.networking.packet;

import com.alcatrazescapee.primalwinter.util.Config;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class WeatherPacket {
    private final float fogDensity;
    private final int snowDensity;
    private final boolean windSounds;
    private final boolean weatherRenderChanges;

    public WeatherPacket(float fogDensity, int snowDensity, boolean windSounds, boolean weatherRenderChanges) {
        this.fogDensity = fogDensity;
        this.snowDensity = snowDensity;
        this.windSounds = windSounds;
        this.weatherRenderChanges = weatherRenderChanges;
    }

    public WeatherPacket(FriendlyByteBuf buffer) {
        this.fogDensity = buffer.readFloat();
        this.snowDensity = buffer.readInt();
        this.windSounds = buffer.readBoolean();
        this.weatherRenderChanges = buffer.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.fogDensity);
        buffer.writeInt(this.snowDensity);
        buffer.writeBoolean(this.windSounds);
        buffer.writeBoolean(this.weatherRenderChanges);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Config.INSTANCE.fogDensity.set(Float.valueOf(this.fogDensity));
            Config.INSTANCE.snowDensity.set(this.snowDensity);
            Config.INSTANCE.windSounds.set(this.windSounds);
            Config.INSTANCE.weatherRenderChanges.set(this.weatherRenderChanges);
        });
        return true;
    }
}

